Scriptname SuH_Main extends Quest  

;	SuH_Main is the main quest script for Succubus Heart. This script manages update code, captured events not requiring an object reference, and registered mod events as well as any function calls that need to run on every player load. Update code is called from SuH_Main_Player with onPlayerLoadGame

SuH_Fun property _f auto
SuH_Status property _s auto
DialogueFollowerScript Property DialogueFollower Auto
Quest Property pDialogueFollower  Auto

Function InitProperties()
	_s = Game.GetFormFromFile(0x16E496, "Succubus Heart.esp") as SuH_Status
	_f = Game.GetFormFromFile(0x814, "Succubus Heart.esp") as SuH_Fun
endFunction

;	MODupdate
Function MODupdate()
	if _s.IsRunning() == False
		Debug.MessageBox(": Succubus Heart :\n!!! FATAL ERROR !!!\nMod failed to initiate properly, please load and try initiating again. \n If you're updating from before 5.0 please install 4.6 first! Load your save and create a new save with 4.6 installed, then 5.0 will initiate properly.(Check ReadMe for more info)")
	endIf
	;	Always Run
	;MiscUtil.PrintConsole("SUH Main Always Run")
	_s.InitProperties()
	_f.InitProperties()
	
	int modVersion = _s.SuH_MODversion
	
	if modVersion > 0 ; if mod has been started on this save
		_s.SuH_runupdates = true ; Set to run "registered for" updates, if this is ever disable-able add additional checks
		
		int i = 0 ; reset pet spells to ensure OnUpdate is functioning properly
		while i < _s.SuH_petactoralive.Length
			actor petactor = _s.SuH_petactoralive[i]
			if petactor != none
				if petactor.IsDisabled() == false
					petactor.RemoveSpell(_s.SuH_spell_pet) ; reset pet tracking spell
					petactor.AddSpell(_s.SuH_spell_pet)
				endIf
			endIf
				i += 1
		endWhile
	endIf
	
	_f.PC_recalculateBDSM()
	
	; NOTE : Re-remove Status Regen that's disabled, Skyrim resets them to default when loading a save
	if _s.SuH_SETdisablehealthrecovery > 0.0
		_s.playerRef.SetActorValue("HealRate", 0)
	endIf
	if _s.SuH_SETdisablemagickarecovery > 0.0
		_s.playerRef.SetActorValue("MagickaRate", 0)
	endIf
	if _s.SuH_SETdisablestaminarecovery > 0.0
		_s.playerRef.SetActorValue("StaminaRate", 0)
	endIf
	;	Re-apply carry weight fix
	if _s.SuH_SETcarrycorrect > 0
		_s.PlayerRef.SetActorValue("carryweight", (_s.SuH_SETcarrycorrect + 300))
	endIf
	
	;	Initial Set-Up
	if modVersion < 100
		;	Grant bonus stats based on current base status
		_s.SuH_PCScaphealth = Math.Floor(_s.PlayerRef.GetBaseActorValue("Health"))
		_s.SuH_PCScapmagicka = Math.Floor(_s.PlayerRef.GetBaseActorValue("Magicka"))
		_s.SuH_PCScapstamina = Math.Floor(_s.PlayerRef.GetBaseActorValue("Stamina"))
	endIf
	
	;	Register Mod Event when Loading
	;	First unregister in-case they got stuck or API change
		;;MiscUtil.PrintConsole("SUH UnregisterForModEvent")
		UnRegisterForModEvent("NPCtracker_Added")
		UnRegisterForModEvent("NPCtracker_Start")
		UnRegisterForModEvent("NPCtracker_Orgasm")
		UnRegisterForModEvent("NPCtracker_End")
		UnRegisterForModEvent("ostim_thread_start")
		UnRegisterForModEvent("ostim_actor_orgasm")
		UnRegisterForModEvent("ostim_thread_end")
	if _s.SuH_Frame_SexLab > 0 ; SexLab
		;;MiscUtil.PrintConsole("SUH SL Registers")
		_s.SexLab.TrackFaction(_s.SuH_tracker,"NPCtracker") ; Set SL tracking NPC faction
		RegisterForModEvent("NPCtracker_Added","anim_NPC_Added_SL")
		RegisterForModEvent("NPCtracker_Start","anim_NPC_Start_SL")
		RegisterForModEvent("NPCtracker_Orgasm","anim_NPC_Orgasm_SL")
		RegisterForModEvent("NPCtracker_End","anim_NPC_End_SL")
		;RegisterForModEvent("PlayerTrack_Added","anim_PC_Added")
		;RegisterForModEvent("PlayerTrack_Start","anim_PC_Start")
		;RegisterForModEvent("PlayerTrack_Orgasm","anim_PC_Orgasm")
		;RegisterForModEvent("PlayerTrack_End","anim_PC_End")
	endif
	if _s.SuH_Frame_OStim > 0 ; OStim
		;;MiscUtil.PrintConsole("SUH OS Registers")
		;RegisterForModEvent("NPCtracker_Added","anim_NPC_Added") called pre-start
		RegisterForModEvent("ostim_thread_start","anim_NPC_Start_OS")
		RegisterForModEvent("ostim_actor_orgasm","anim_NPC_Orgasm_OS")
		RegisterForModEvent("ostim_thread_end","anim_NPC_End_OS")
		;RegisterForModEvent("PlayerTrack_Added","anim_PC_Added") called pre-start
		;RegisterForModEvent("ostim_start","ostim_anim_PC_Start")
		;RegisterForModEvent("ostim_orgasm","ostim_anim_PC_Orgasm")
		;RegisterForModEvent("ostim_end","ostim_anim_PC_End")
	endIf
	
	;	Register for KeyDown/Up
	_f.registerforkeybind()
	
	;	Previous Patches
	if modVersion < 4007000
		_s.playerRef.AddSpell(_s.SuH_spell_nightsembrace)
		_s.PlayerRef.AddSpell(_s.SuH_spell_selfpleasure)
		_s.playerRef.AddSpell(_s.SuH_spell_teliRealm)
		_s.playerRef.AddSpell(_s.SuH_spell_sexualenrage)
		_s.playerRef.AddSpell(_s.SuH_spell_sexualentice)
		_s.PlayerRef.AddSpell(_s.SuH_spell_petself)
		_s.PlayerRef.AddSpell(_s.SuH_spell_pettarget)
		
		_s.SuH_petactorbases = new ActorBase[25]
		_s.SuH_petlevels = new int[25]
		_s.SuH_petxps = new int[25]
	endIf
	if modVersion < 4008000
		_s.SuH_petnames = new string[25]
	endIf
	if modVersion < 4012005
		_s.SuH_petactoralive = new Actor[25]
	endIf
	if modVersion < 4012007
		if modVersion > 0
			_s.SuH_PCScaphealthdown = 0
			_s.SuH_PCScapmagickadown = 0
			_s.SuH_PCScapstaminadown = 0
			_f.PassiveReset(1)
			debug.messagebox(": Succubus Heart Update :\nPassives have been reset!")
		endIf
	endIf
	if modVersion < 4013011
		
		_s.SuH_pettrait0 = new int[25]
		_s.SuH_pettrait1 = new int[25]
		_s.SuH_pettrait2 = new int[25]
		if modVersion > 0
			_f.PetCollapseArray()
		endIf
	endIf
	if modVersion < 5000007
		_s.PlayerRef.AddSpell(_s.SuH_spell_remotechest)
	endIf
	;	Current Patch
	if modVersion < 5003007
	
		UnRegisterForModEvent("ostim_thread_orgasm")
		
			
		;debug.Notification("Succubus Heart : 5.2.0 Release Installed")
		debug.Notification("Succubus Heart : 5.3.7 DEV Installed")
		debug.MessageBox("< Succubus Heart >\nWARNING : The installed version of Succubus Heart is a DEV version and is untested/incomplete. Some features may be missing, incomplete, or outright broken!\nSince Dev Builds are not fully tested, please do not use these versions on your main save, use a backup or separate character! When installing the newest Stable Release use a save that never installed the DEV versions for the best experience.\nRemember to report any issues you find on Discord, Happy Draining!")
		
		_s.SuH_MODversion = 5003007
	endIf
	
	if modVersion > _s.SuH_MODversion
		debug.MessageBox("< Succubus Heart >\nWARNING : This save previously had a newer version of Succubus Heart installed! Continuing with this older version may lead to issues or even result in your save completely breaking!")
	endIf
	
	_s.SuH_MPlayertickcounter = 0 ; reset Main_Player tick counter
	RegisterForSingleupdate(8.0) ; Tick in 8 seconds
endFunction

Event OnInit()
	InitProperties()
endEvent

Event OnUpdate()
	if _s.SuH_MPlayertickcounter == 0 && _s.SuH_runupdates == true
		Debug.MessageBox(": Succubus Heart :\n!!! FATAL ERROR !!!\nSuH_Main_Player update script appears to be stuck, please load a previous save from before this error had occured. If possible, please send in a bug report as well, thank you!")
	else
		_s.SuH_MPlayertickcounter = 0
	endIf
	RegisterForSingleupdate(300.0) ; Tick in 300 seconds
endEvent


;		RegisterForModEvent("ostim_thread_start","ostim_anim_NPC_Start")
;		RegisterForModEvent("ostim_thread_orgasm","ostim_anim_NPC_Orgasm")
;		RegisterForModEvent("ostim_thread_end","ostim_anim_NPC_End")

;	NPC Animation Added / Started
;		SL = SexLab
;		OS = OStim
Event anim_NPC_Added_SL(form ActorRef, int threadId)
	if _s.SuH_Frame_SexLab > 1
		actor StartActor = ActorRef as Actor
		actor[] animActor = _s.SexLab.HookActors(threadId)
		anim_NPC_Added(StartActor, animActor)
	endIf
endEvent

Event anim_NPC_Start_SL(form ActorRef, int threadId)
	if _s.SuH_Frame_SexLab > 1
		actor StartActor = ActorRef as Actor
		anim_NPC_Start(StartActor)
	endIf
endEvent

Event anim_NPC_Start_OS(String EventName, String sceneId, Float threadID, Form Sender)
	;MiscUtil.PrintConsole("anim_NPC_Start_OS")
	if threadID == 0 && _s.SuH_Frame_OStim > 1
		actor[] animActor = OThread.GetActors(0)
		int i = 0
		while i < animActor.Length
			if animActor[i] != _s.PlayerRef
				anim_NPC_Added(animActor[i], animActor)
				anim_NPC_Start(animActor[i])
			endIf
			i += 1
		endWhile
	endIf
endEvent

Function anim_NPC_Added(actor StartActor, actor[] animActor)
	;MiscUtil.PrintConsole("anim_NPC_Added")
	if _s.SuH_SETpreventactdeath > 0
		StartActor.startdeferredkill() ; Start Deferred Kill
	endIf
	
	int i = 0
	while i < animActor.Length
		animActor[i].StopCombatAlarm()
		i += 1
	endWhile
endFunction

Function anim_NPC_Start(actor StartActor)
	;MiscUtil.PrintConsole("anim_NPC_Start")
	if _s.SuH_runupdates == false
		return
	endif
	
	;char.startdeferredkill() ; Start Deferred Kill
	
	if _s.SuH_SETclearactor > 0
		StartActor.ClearExtraArrows()
	endIf
endFunction


;	NPC Orgasm
;		SL = SexLab
;		OS = OStim
Event anim_NPC_Orgasm_SL(form ActorRef, int threadId)
	if _s.SuH_Frame_SexLab > 1
		actor StartActor = ActorRef as actor
		actor[] animActor = _s.SexLab.HookActors(threadId)
		anim_NPC_Orgasm(StartActor, animActor, 1, threadId)
	endIf
endEvent

Event anim_NPC_Orgasm_OS(String EventName, String sceneId, Float threadID, Form Sender)
	;MiscUtil.PrintConsole("anim_NPC_Orgasm_OS")
	if _s.SuH_Frame_OStim > 1
		actor[] animActor = OThread.GetActors(threadID as int)
		int i = 0
		while i < animActor.Length
			if animActor[i] != _s.playerRef
				anim_NPC_Orgasm(animActor[i], animActor, 2)
			endIf
			i += 1
		endWhile
	endif
endEvent

;	NPC Anim Orgasm
Function anim_NPC_Orgasm(actor StartActor, actor[] animActor, int fwork=0, int threadId=0)
	;MiscUtil.PrintConsole("anim_NPC_Orgasm")
	if _s.SuH_runupdates == false || fwork == 0
		return
	endif
	
	actor char = StartActor ; Get Actor (We'll exclude char from results)
	
	;	Check for Player
	int pact = 0
	int i = 0 ; Set array position to 0
	While i < animActor.Length
		if animActor[i] != char
			if animActor[i] == _s.PlayerRef
				pact = 1
			endIf
		endIf
		i += 1
	endWhile
	
	int fluidcount = 1
	
	; Soul Pet orgasm calculation
	if char.IsInFaction(_s.SuH_petfaction)
		if pact == 1 ; if player is involved
			_f.PCE_stattrack("Pettrainorg")
		endIf
		int petslot = _f.PetFindSlot(petactor=char)
		_f.Pet_addXP(char, 40)
		if _s.SuH_pettrait0[petslot] == 11 || _s.SuH_pettrait1[petslot] == 11 || _s.SuH_pettrait2[petslot] == 11
			fluidcount = Utility.RandomInt(1,3)
		endIf
	endIf
	
	;	Hand out fluids
	if animActor.Length > 1 ; If multiple actors are present
		int charGender = -1
		if fwork == 1 ; SexLab
			charGender = _s.SexLab.GetGender(char) ; 0 = male , 1 = female , 2 = male creature , 3 = female creature
		else
			charGender = char.GetLeveledActorBase().GetSex() ; 0 = male, 1 = female
		endIf
		
		i = 0
		while i < animActor.Length
			if animActor[i] != char
				if charGender == 0 ; If giver is Male
					if _s.SuH_SETspermdistribute > 0
						animActor[i].AddItem(_s.SuH_alch_sperm, fluidcount, true)
					endIf
				elseif charGender == 2 ; If giver is male creature
					if _s.SuH_SETspermdistribute > 0
						animActor[i].AddItem(_s.SuH_alch_spermcreature, fluidcount, true)
					endIf
				elseif charGender == 1 ; If giver is Female
					if _s.SuH_SETmilkdistribute > 0
						animActor[i].AddItem(_s.SuH_alch_milk, fluidcount, true)
					endIf
				elseif charGender == 3 ; If giver is Female creature
					if _s.SuH_SETmilkdistribute > 0
						animActor[i].AddItem(_s.SuH_alch_milkcreature, fluidcount, true)
					endIf
				endIf
				if animActor[i] == _s.PlayerRef
					;	Calculate Rare Drop to Player
					int ran = Utility.RandomInt(0,99) + _s.SuH_rank_perfectorgasm as int
					if ran >= 94
						int rare = Utility.RandomInt(0,2)
						if rare == 0
							_s.PlayerRef.AddItem(_s.SuH_alch_vitalitystone, 1, true)
							debug.Notification("Succubus Heart - RARE DROP - Vitality Stone") ; Give to player since they can only be rewarded to the player
						elseif rare == 1
							_s.PlayerRef.AddItem(_s.SuH_alch_empowermentstone, 1, true)
							debug.Notification("Succubus Heart - RARE DROP - Empowerment Stone")
						elseif rare == 2
							_s.PlayerRef.AddItem(_s.SuH_alch_specialtystone, 1, true)
							debug.Notification("Succubus Heart - RARE DROP - Specialty Stone")
						endIf
					endIf
				endIf
			endIf
			i += 1
		endWhile
	else ; If actor is alone
		int charGender = -1
		if fwork == 1 ; SexLab
			charGender = _s.SexLab.GetGender(char) ; 0 = male , 1 = female , 2 = male creature , 3 = female creature
		else
			charGender = char.GetLeveledActorBase().GetSex() ; 0 = male, 1 = female
		endIf
		if charGender == 0 ; If giver is Male
			if _s.SuH_SETspermdistribute > 0
				char.AddItem(_s.SuH_alch_sperm, fluidcount, true)
			endIf
		elseif charGender == 2 ; if giver is male creature
			if _s.SuH_SETspermdistribute > 0
				char.AddItem(_s.SuH_alch_spermcreature, fluidcount, true)
			endIf
		elseif charGender == 1; If giver is Female
			if _s.SuH_SETmilkdistribute > 0
				char.AddItem(_s.SuH_alch_milk, fluidcount, true)
			endIf
		elseif charGender == 3; If giver is Female creature
			if _s.SuH_SETmilkdistribute > 0
				char.AddItem(_s.SuH_alch_milkcreature, fluidcount, true)
			endIf
		endIf
	endIf
	
	; Player Included Proc
	if pact == 1
		
		;	Devious Partner calculation
		if _s.SuH_rank_deviouspartner > 0 ; Steal Gold Passive
			i = 0
			while i < animActor.Length ; Run for each actor
				if animActor[i] != _s.playerRef && animActor[i].IsInFaction(_s.PotentialFollowerFaction) == false && animActor[i].IsInFaction(_s.PlayerPotentialAnimalFaction) == false
					int rand = Utility.RandomInt(1,100) ; Get Chance, if below or equal take item
					if rand <= (_s.SuH_rank_deviouspartner * 20)
						animActor[i].RemoveItem(_s.Gold001, Math.Floor(_s.SuH_PCSdpoint * 0.4), false, _s.playerRef)
					endIf
				endIf
				i += 1
			endWhile
		endIf
		if _s.SuH_rank_deviouspartner2 > 0 ; Steal Item Passive
			i = 0
			while i < animActor.Length ; Run for each actor
				if animActor[i] != _s.playerRef && animActor[i].IsInFaction(_s.PotentialFollowerFaction) == false && animActor[i].IsInFaction(_s.PlayerPotentialAnimalFaction) == false
					int rand = Utility.RandomInt(1,100) ; Get chance, if below or equal take item
					if rand <= (_s.SuH_rank_deviouspartner2 * 10)
						int itemcount = animActor[i].GetNumItems() ; Grab inventory item count
						if itemcount > 0
							rand = Utility.RandomInt(0, (itemcount - 1)) ; Pick a random item for our first try
							form formfound = animActor[i].GetNthForm(rand)
							bool esc = false
							int skipnum = -1
							while esc != true
								if skipnum >= 0 ; If we've skipped an item just try the next item on the list, starting from the top (0)
									formfound = animActor[i].GetNthForm(skipnum)
								endIf
								if formfound != none && formfound != _s.Gold001 && formfound.GetName() != "" ; If form is invalid [need to find a way to add quest tagged items here]
									animActor[i].RemoveItem(formfound, 1, false, _s.playerRef) ; take 1 of the item
									esc = true
								else ; If failed, add skip to next item in list
									skipnum +=1
									if skipnum >= itemcount ; If we've skipped the full inventory just give up
										esc = true
									endIf
								endIf
							endwhile
						endIf
					endIf
				endIf
				i += 1
			endWhile
		endIf
		
		if char.GetRelationshipRank(_s.PlayerRef) >= 3
			_f.PCE_stattrack("Allyorgasm")
		endIf
	endIf
endFunction

;	NPC Animation End
;		SL = SexLab
;		OS = OStim
Event anim_NPC_End_SL(form ActorRef, int threadId)
	;MiscUtil.PrintConsole("anim_NPC_End_SL")
	if _s.SuH_Frame_SexLab > 1
		;MiscUtil.PrintConsole("SexLab enabled, running code")
		actor StartActor = ActorRef as actor
		actor[] animActor = _s.SexLab.HookActors(threadId)
		bool playerInvolved = false
		int i = 0
		While i < animActor.Length
			if animActor[i] == _s.playerRef
				playerInvolved = true
				;MiscUtil.PrintConsole(i + " is Player")
				i = 999
			else
				;MiscUtil.PrintConsole(i + " is Not Player")
			endIf
			i += 1
		endWhile
		;MiscUtil.PrintConsole("Calling End Event")
		anim_NPC_End(StartActor, animActor, playerInvolved)
	endIf
	;MiscUtil.PrintConsole("Exit Event")
endEvent

Event anim_NPC_End_OS(String EventName, String sceneId, Float index, Form Sender)
	;MiscUtil.PrintConsole("anim_NPC_End_OS")
	; Do nothing since we can't get actors from this event
	; kept here in-case a cache system is implemented or OStim updates with proper functionality
endEvent

;	NPC Anim End
Function anim_NPC_End(actor StartActor, actor[] animActor, bool playerInvolved)
	;MiscUtil.PrintConsole("anim_NPC_End " + animActor.Length)
	if _s.SuH_runupdates == false
		return
	endif
	
	actor char = StartActor ; Get Actor
	actor playerRef = _s.playerRef
	
	if char.IsInFaction(_s.SuH_petfaction)
		int x = _f.PetFindSlot(char)
		;	Check 'aggressive partner' trait
		if _s.SuH_pettrait0[x] == 7 || _s.SuH_pettrait1[x] == 7 || _s.SuH_pettrait2[x] == 7
			int i = 0
			while i < animActor.Length
				int y = (10 + (_s.SuH_petlevels[x] * 4))
				if _s.SuH_SETtraitwontkill > 0 && animActor[i].GetActorValue("Health") <= y ; if act traits won't kill is enabled, check NPC health
					y = Math.Floor(animActor[i].GetActorValue("Health") - 5)
				endIf
				animActor[i].DamageActorValue("Health", y)
				i += 1
			endWhile
		endIf
		;	Check 'exhausting partner' trait
		if _s.SuH_pettrait0[x] == 8 || _s.SuH_pettrait1[x] == 8 || _s.SuH_pettrait2[x] == 8
			int i = 0
			while i < animActor.Length
				int y = (40 + (_s.SuH_petlevels[x] * 10))
				animActor[i].DamageActorValue("Magicka", y)
				animActor[i].DamageActorValue("Stamina", y)
				i += 1
			endWhile
		endIf
	endIf
	
	if _s.SuH_SETcscooldown > 0
		char.AddSpell(_s.SuH_sex_CScd, false)
	endIf
	
	if _s.SuH_SETpreventactdeath > 0
		char.EndDeferredKill()
	endIf
	
	;	Check if actor is marked as a Succubus, then trigger drain based on level
	if char.IsInFaction(_s.SuH_Succubus)
		int drainbylvl = math.floor(char.GetLevel())
		int i = 0
		while i < animActor.Length
			actor charvict = animActor[i]
			if charvict != char && charvict != playerRef && charvict.IsInFaction(_s.SuH_Succubus) == false
				_f.drainStat_Health(drainbylvl, char, charvict)
				_f.drainStat_Magicka(drainbylvl, char, charvict)
				_f.drainStat_Stamina(drainbylvl, char, charvict)
				if playerInvolved == false && _s.SuH_SETallowdrainkill > 0
					if _s.SuH_SETnpcabsorb == 1 || _s.SuH_SETnpcabsorb == 2 && char.GetRelationshipRank(charvict) < 3 || _s.SuH_SETnpcabsorb == 3 && char.GetRelationshipRank(charvict) < 0
						Utility.wait(0.25)
						char.DamageActorValue("Health", 9999999999)
					endIf
				endIf
			endIf
			i += 1
		endWhile
	endif
		
	if playerInvolved == true ; If player involved
		;	Soul Tap calculation, apply soul trap if not ally or pet
		if _s.SuH_rank_soultap > 0 && playerRef.GetRelationshipRank(char) < 3 && char.IsInFaction(_s.SuH_petfaction) == false
			int rand = Utility.RandomInt(1,5)
			if rand <= _s.SuH_rank_soultap
				_s.SuH_spell_SoulTrap.Cast(playerRef, char)
			endIf
		endIf
		;	Drain Kill calculation
		if _s.SuH_SETallowdrainkill > 0 && char.IsEssential() == false && char.GetLeveledActorBase().IsProtected() == false
			if _s.SuH_SETnpcabsorb == 1 || _s.SuH_SETnpcabsorb == 2 && char.GetRelationshipRank(playerRef) < 3 || _s.SuH_SETnpcabsorb == 3 && char.GetRelationshipRank(playerRef) < 0
				if _s.SuH_SETallowdrainkill == 1 || _s.SuH_SETallowdrainkill == 2 && char.GetRelationshipRank(PlayerRef) < 3 || _s.SuH_SETallowdrainkill == 3 && char.GetRelationshipRank(PlayerRef) < 0
					Utility.wait(0.25)
					If _s.SuH_SETalwaysdrainkill > 0 || char.GetActorValue("Health") < 1.5 || char.GetBaseActorValue("Health") < 1.5 ; if always drain kill or health is below threshold
						;MiscUtil.PrintConsole("SUH drain kill triggered")
						if _s.SuH_rank_soultapplus > 0 ; if Soul Siphon plus is unlocked, drain remaining max status up-to max fluid status bonus
							int x = Math.ceiling(char.GetBaseActorValue("Health"))
							if x > _s.SuH_PCSfluidhealth
								x = _s.SuH_PCSfluidhealth
							endif
							_f.drainStat_Health(x, playerRef, char)
							x = Math.ceiling(char.GetBaseActorValue("Magicka"))
							if x > _s.SuH_PCSfluidmagicka
								x = _s.SuH_PCSfluidmagicka
							endif
							_f.drainStat_Magicka(x, playerRef, char)
							x = Math.ceiling(char.GetBaseActorValue("Stamina"))
							if x > _s.SuH_PCSfluidstamina
								x = _s.SuH_PCSfluidstamina
							endif
							_f.drainStat_Stamina(x, playerRef, char)
						endIf
						char.DamageActorValue("Health", 9999999999)
						;MiscUtil.PrintConsole("SUH damage dealt and sending stat track")
						_f.PCE_stattrack("Killdrain")
					endIf
				endIf
			endIf
		endIf
	endIf
	;MiscUtil.PrintConsole("SUH drain kill function over, checking AI fix and ending")
	; Sexlab holding AI Package ##00e50E - this package can get stuck and stops NPCs from interacting after animations
	if _s.SuH_SETslaifix > 0 && _s.SuH_Frame_SexLab > 0 ; if fix SexLab ai stuck bug is enabled
		;debug.MessageBox("is AI enabled : " + char.IsAiEnabled() + "\nis in combat : "+ char.isInCombat() + "\nCurrent Package : " + char.GetCurrentPackage())
		Utility.wait(5.0) ; Wait 5 seconds to check if SexLab has disabled the package
		if char.GetCurrentPackage() == _s.SexlabDoNothing ; if do nothing ai package is still active
			char.EvaluatePackage() ; re-evaluate ai packages
		endIf
	endIf
endFunction
